/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.signedit;

import java.io.File;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="signedit", version="1.12.2-4", name="SignEdit", acceptedMinecraftVersions="[1.12.2]")
public class SignEdit {
    public static final String MODID = "signedit";
    public static final String VERSION = "1.12.2-4";
    public static final String MODNAME = "SignEdit";
    private static final Item DEFAULT_EDITOR = Items.field_151155_ap;
    private static Item editor;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        editor = SignEdit.getItemFromName(SignEdit.loadEditorItemNameFromConfig());
    }

    private static Item getItemFromName(String editorItemName) {
        if (editorItemName == null) {
            return null;
        }
        Item editor = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(editorItemName));
        if (editor == null) {
            return DEFAULT_EDITOR;
        }
        return editor;
    }

    private static String loadEditorItemNameFromConfig() {
        Configuration cfg = new Configuration(new File("config/signedit.cfg"));
        cfg.load();
        String editorItemName = cfg.get(MODNAME, "editor", "minecraft:sign", "The player must hold this item to edit signs. Enter in the format modid:itemname. Default: 'minecraft:sign'. Use '*' to always allow editing regardless of held items.").getString();
        if (editorItemName.equals("*")) {
            return null;
        }
        cfg.save();
        return editorItemName;
    }

    @SubscribeEvent
    public void editSign(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer().func_70093_af()) {
            return;
        }
        if (!SignEdit.isHoldingEditor(event.getEntityPlayer())) {
            return;
        }
        BlockPos pos = new BlockPos(event.getHitVec());
        IBlockState state = event.getWorld().func_180495_p(pos);
        if (state.func_177230_c() != Blocks.field_150444_as && state.func_177230_c() != Blocks.field_150472_an) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        TileEntity tileentity = event.getWorld().func_175625_s(pos);
        if (tileentity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            sign.func_145912_a(player);
            ObfuscationReflectionHelper.setPrivateValue(TileEntitySign.class, (Object)sign, (Object)true, (String[])new String[]{"field_145916_j", "isEditable"});
            player.func_175141_a(sign);
        }
    }

    private static boolean isHoldingEditor(EntityPlayer player) {
        if (editor == null) {
            return true;
        }
        for (ItemStack stack : player.func_184214_aD()) {
            if (stack.func_77973_b() != editor) continue;
            return true;
        }
        return false;
    }
}

